uniform sampler2D myTexture;

uniform vec4 mColor;

uniform vec4 base0;
uniform vec4 base1;
uniform vec4 base2;

uniform vec4 color0;
uniform vec4 color1;
uniform vec4 color2;

vec4 getColor( vec2 coord )
{
	vec4 col1 = texture2D(myTexture, coord );
	vec4 eps = vec4(0.009, 0.009, 0.009, 0.009);	
	
	if( all( greaterThanEqual(col1, base0 - eps)) && all( lessThanEqual(col1, base0 + eps) ) )
		col1 = color0;	
	
	if( all( greaterThanEqual(col1, base1 - eps)) && all( lessThanEqual(col1, base1 + eps) ) )
		col1 = color1;		
	
	if( all( greaterThanEqual(col1, base2 - eps)) && all( lessThanEqual(col1, base2 + eps) ) )
		col1 = color2;
		
	return col1;
}

void main (void)
{

	vec4 col = getColor( vec2(gl_TexCoord[0]) );
	vec4 col1 = col;

	float dist = 0.00075;

	vec4 col2 = getColor( vec2(gl_TexCoord[0] + vec2(dist,0.0) ) );	
	vec4 col3 = getColor(vec2(gl_TexCoord[0] - vec2(dist,0.0)));	
		
	if ( col2.a != 0 && col3.a != 0 )
		col = col1 * 0.333 + col2 * 0.333 + col3 * 0.333;

	vec4 col4 = getColor(vec2(gl_TexCoord[0] + vec2(0.0,dist)));	
	vec4 col5 = getColor(vec2(gl_TexCoord[0] - vec2(0.0,dist)));

	if ( col4.a != 0 && col5.a != 0 )		
		col = (col1 * 0.333 + col4 * 0.333 + col5 * 0.333) * 0.5 + col * 0.5;	

		
	
		
	//float xper = (int(gl_TexCoord[0].x * 1000)) % 20;
	//col.rgb -= xper / 200.0;
	
	//float xper2 = (int(gl_TexCoord[0].y * 1000)) % 20;
	//col.rgb -= xper2 / 200.0;	
	
	
    gl_FragColor = col * mColor;
}
