uniform sampler2D baseTexture;
uniform sampler2D shadowTexture;
uniform vec3 mLightPos;
uniform float diss;

varying vec3 normal;
//varying vec3 lightDir;
//varying vec4 v;
varying vec3 vertex_world;

void main (void)
{
	

	vec4 lightColor = vec4(1,1,1,1);
	//vec4 glob = vec4(0.4,0.4,0.4,1);
	vec4 glob = vec4(0,0,0,1);
	
    vec4 col = texture2D(baseTexture, vec2(gl_TexCoord[0]));
    vec4 colShad = texture2D(shadowTexture, vec2(gl_TexCoord[1]));	
	
	
	
	float cut = 5 / 16.0;
	vec3 vw = ( ivec3(vertex_world) / cut ) * cut;
	
	float d = length(mLightPos - vw);
	float att = 1.0 / ( 0.01 + (0.001*d) + (0.00005*d*d) );	

	
	//vec4 final_color = 
	//(gl_FrontLightModelProduct.sceneColor * vec4(1,0.5,0.5,0.5)) + 
	//(gl_LightSource[0].ambient * gl_FrontMaterial.ambient);
	
	vec4 final_color = glob;
							
	vec3 N = normalize(normal);
	//vec3 L = normalize(mLightPos - v);

	
	//calculate Diffuse Term:  
	//vec4 Idiff = gl_FrontLightProduct[0].diffuse * max(dot(N,L), 0.0) * att;
	//Idiff.a = 1;
	//Idiff = clamp(Idiff, 0.0, 1.0);   


	float rnd = sin(vw.x) * 1.5 + cos(vw.x / 10) * 2;
	if (vw.y > (diss * 40 + rnd * ( 1-diss ) * 2 ) + 10 )
	{
		col.a = 0;
	}

	
	gl_FragColor =  col * colShad;	
	

		
}