uniform sampler2D baseTexture;
uniform sampler2D shadowTexture;

uniform float diss;
varying vec3 vertex_world;

uniform vec4 mColor;


void main (void)
{

	
    vec4 col = texture2D(baseTexture, vec2(gl_TexCoord[0]));
    vec4 colShad = texture2D(shadowTexture, vec2(gl_TexCoord[1]));	
	

	float cut = 10.0 / 16.0;
	vec3 vw = ( ivec3(vertex_world / cut ) ) * cut;
	


	//float rnd = sin(vw.x) * 1.5 + cos(vw.x / 10) * 6;
	float rnd = sin(vw.x) + cos(vw.x * 4);	
	
	float diff = 10 + (diss * 30 + rnd * (1-diss)*2);
	if (vw.y > diff )
	{
		col.a = 0;
	}

	/// *idiff entfernt
	gl_FragColor =  col * colShad * mColor;	

		
}